/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.sdgraph;

import com.google.common.base.Preconditions;
import cz.insophy.inplan.sdgraph.AbstractSdgEdge;
import cz.insophy.inplan.sdgraph.SdgNode;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.store.StoreActivity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class SdgEdgeImpl
extends AbstractSdgEdge {
    private final StoreActivity sourceStoreActivity;
    @Nullable
    private final StoreActivity destinationStoreActivity;
    private final double qty;

    SdgEdgeImpl(int orderKey, @Nonnull SdgNode startNode, @Nonnull SdgNode endNode, @Nonnull StoreActivity sourceStoreActivity, @Nullable StoreActivity destinationStoreActivity, double qty) {
        super(orderKey, startNode, endNode);
        this.sourceStoreActivity = Preconditions.checkNotNull(sourceStoreActivity);
        this.destinationStoreActivity = destinationStoreActivity;
        this.qty = qty;
    }

    @Override
    public long getStartTime() {
        return this.sourceStoreActivity.getTime();
    }

    @Override
    public long getEndTime() {
        return this.destinationStoreActivity == null ? Long.MAX_VALUE : this.destinationStoreActivity.getTime();
    }

    @Override
    @Nonnull
    public StoreActivity getSourceStoreActivity() {
        return this.sourceStoreActivity;
    }

    @Override
    @Nullable
    public StoreActivity getDestinationStoreActivity() {
        return this.destinationStoreActivity;
    }

    @Override
    @Nonnull
    public Material getMaterial() {
        return this.sourceStoreActivity.getMaterial();
    }

    @Override
    public double getQty() {
        return this.qty;
    }

    public String toString() {
        return this.getSourceNode() + " -(" + this.qty + ")-> " + this.getDestinationNode();
    }
}

